// MainFrm.cpp : CMainFrame NX̓̒`s܂B
//

#include "stdafx.h"
#include "IB.h"

#include "MainFrm.h"
#include "InteractionToolView.h"
#include "IBDoc.h"
#include "process.h"
#include "IBFlowView.h"
#include "IBOleDropSource.h"
#include "XISLTag.h"
#include "XISLCallTag.h"
#include "XISLDialogTag.h"
#include "FSMClient.h"
#include "SSMClient.h"
#include "FSMOutputDlg.h"
#include "OutputTTSDlg.h"
#include "FSMClient.h"
#include "SSMClient.h"
#include "CFGEngineDlg.h"
#include "TestFileSelect.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
CInteractionToolView *pIToolView = NULL;
CXISLRootTag *g_pAppRootTag = NULL;
CXISLVarList *g_pAppVarList = NULL;

int nXISLFrmNum = 0;
int nContentsFrmNum = 0;

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_INITMENUPOPUP()
	ON_WM_CLOSE()
	ON_COMMAND(IDM_RUN_FSM, OnRunFsm)
	ON_COMMAND(IDM_RUN_SSM, OnRunSsm)
	ON_COMMAND(IDM_RUN_TEST, OnRunTest)
	ON_COMMAND(IDM_CFG_ENGIN_NOXISL,OnCfgEngin)
	ON_UPDATE_COMMAND_UI(IDM_RUN_SSM, OnUpdateRunSsm)
	ON_UPDATE_COMMAND_UI(IDM_RUN_FSM, OnUpdateRunFsm)

	//}}AFX_MSG_MAP
	// _CAOo[̃Rg[̃Cxg
	ON_COMMAND( IDC_TAGBAR_XISL_DIALOG, OnTagDialogClick )
	ON_COMMAND( IDC_TAGBAR_XISL_EXCHANGE, OnTagExchangeClick )
	ON_COMMAND( IDC_TAGBAR_XISL_BEGIN, OnTagBeginClick )
	ON_COMMAND( IDC_TAGBAR_XISL_END, OnTagEndClick )
	ON_COMMAND( IDC_TAGBAR_XISL_SEQ, OnTagSeqClick )
	ON_COMMAND( IDC_TAGBAR_XISL_PAR, OnTagParClick )
	ON_COMMAND( IDC_TAGBAR_XISL_ALT, OnTagAltClick )
	ON_COMMAND( IDC_TAGBAR_XISL_GOTO, OnTagGotoClick )
	ON_COMMAND( IDC_TAGBAR_XISL_CALL, OnTagCallClick )
	ON_COMMAND( IDC_TAGBAR_XISL_RETURN, OnTagReturnClick )
	ON_COMMAND( IDC_TAGBAR_XISL_ASSIGN, OnTagAssignClick )
	ON_COMMAND( IDC_TAGBAR_XISL_SWITCH, OnTagSwitchClick )
	ON_COMMAND( IDC_TAGBAR_XISL_EXIT, OnTagExitClick )
	ON_COMMAND( IDC_TAGBAR_XISL_IF, OnTagIFClick)
	ON_COMMAND( IDC_TAGBAR_XISL_PROMPT, OnTagPromptClick)
	ON_COMMAND( IDC_TAGBAR_XISL_REPROMPT, OnTagRepromptClick)
	ON_COMMAND( IDC_MODBAR_INPUT_SPEECH, OnModSpeechClick )
	ON_COMMAND( IDC_MODBAR_INPUT_TOUCH, OnModTouchClick )
	ON_COMMAND( IDC_MODBAR_OUTPUT_WINDOW, OnModWindowClick )
	ON_COMMAND( IDC_MODBAR_OUTPUT_TTS, OnModTTSClick )
	ON_COMMAND( IDC_MODBAR_OUTPUT_FSM, OnModFsmClick )
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_PATH,
	ID_INDICATOR_FORM,
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/
CStatusBar *g_pStBar;
CDialogBar *g_pModBar;
CDialogBar *g_pTagBar;
CIBFlowView *g_pOprTargetView = NULL;

CMainFrame::CMainFrame()
{
	// TODO: ̈ʒuɃȍR[hǉĂB
	g_pStBar = &m_wndStatusBar;
//	g_pModBar = &m_wndMODDlgBar;
	g_pTagBar = &m_wndTAGDlgBar;
	m_pTargetView = NULL;
	m_nDropOKItem = ID_DROPOK_DIALOG;

	m_pFSMClient = NULL;
	m_pSSMClient = NULL;
	ZeroMemory(&m_impi, sizeof(PROCESS_INFORMATION));
	ZeroMemory(&m_fepi, sizeof(PROCESS_INFORMATION));
	m_startFsm=FALSE;

}

CMainFrame::~CMainFrame()
{
	if(g_pAppVarList)
	{
		delete g_pAppVarList;
		g_pAppVarList = NULL;
	}
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // 쐬Ɏs
	}

	// _eB_CAOo[
/*	if ( !m_wndMODDlgBar.Create( this,IDD_MODALITY_BAR,
		WS_VISIBLE | WS_CHILD |  CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_RIGHT,
		IDW_MODALITY_DIALOG_BAR ) )
	{
		TRACE( "Failed to create dialog bar.\n" );
		return -1;
	}*/

	// XISL^O_CAOo[
	if ( !m_wndTAGDlgBar.Create( this,IDD_TAG_BAR,
		WS_VISIBLE | WS_CHILD |  CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_RIGHT,
		IDW_TAG_DIALOG_BAR ) )
	{
		TRACE( "Failed to create dialog bar.\n" );
		return -1;
	}

	// TODO: c[ o[hbLO\ɂȂꍇ͈ȉ̂Rs폜
	//       ĂB

	CRect toolRect;
	
	m_wndToolBar.SetWindowText("Cc[");
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar,AFX_IDW_DOCKBAR_TOP);

	// hbLOEChE
	CRect rect;
	GetClientRect( &rect );
	if ( !m_wndSTCBar.Create( this, CSize( 200, rect.Height() ), IDW_STC_BAR ) ) {
		TRACE( "Failed to create docking window.\n" );
		return -1;
	}
	m_wndSTCBar.SetBarStyle( m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC );
	m_wndSTCBar.EnableDocking( CBRS_ALIGN_ANY );
	DockControlBar( &m_wndSTCBar, AFX_IDW_DOCKBAR_LEFT);

	m_wndTAGDlgBar.SetWindowText("Θbic[");
	ShowControlBar(&m_wndTAGDlgBar, TRUE, FALSE);
	m_wndTAGDlgBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
//	JointToolBar(this,&m_wndTAGDlgBar,&m_wndToolBar);
	DockControlBar(&m_wndTAGDlgBar);//, AFX_IDW_DOCKBAR_RIGHT);
	
/*	m_wndMODDlgBar.SetWindowText("_eBc[");
	m_wndMODDlgBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
//	JointToolBar(this,&m_wndMODDlgBar,&m_wndTAGDlgBar);
	DockControlBar(&m_wndMODDlgBar);//,AFX_IDW_DOCKBAR_RIGHT);*/

	// r[̒ǉ
	m_wndSTCBar.AddView("InteractionTree", RUNTIME_CLASS( CInteractionToolView ) );
	pIToolView = (CInteractionToolView*)m_wndSTCBar.GetView(RUNTIME_CLASS(CInteractionToolView));

	UINT StStyle = m_wndStatusBar.GetPaneStyle(1) | SBPS_STRETCH;
	m_wndStatusBar.SetPaneStyle(1,StStyle);


	CWinApp *pApp = AfxGetApp();
	m_nValidate = pApp->GetProfileInt("ENGINE","Validate",0);
	//eGW̐ݒ肪ȂĂȂH
	if(m_nValidate == 0)
	{
		CCFGEngineDlg cfgEngDlg;
		cfgEngDlg.DoModal();
		m_nValidate = cfgEngDlg.GetnValidate();//GW̐ݒԂ擾
	}
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	//JgfBNgIB̂fBNgɂ
	int dir_length=0;
	char cPath[MAX_PATH];
	GetModuleFileName(NULL, cPath, sizeof(cPath));//AvP[V̂fBNg擾(t@Ct)
	dir_length = strlen(cPath);//擾t@Cl[̒擾(fBNg܂)
	//AvP[V
	while(dir_length){
		if(cPath[dir_length]=='\\'){
			cPath[dir_length]='\0';
			break;
		}
		else
			dir_length--;
	}
	//JgfBNgݒ
	SetCurrentDirectory(cPath);

	//GW̌Ăяo
	if(m_nValidate!=0){// && m_startFsm==FALSE){
		OnRunSsm();
		OnRunFsm();
		//m_startFsm=TRUE;
	}

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs CāAWindow NXX^C
	//       CĂB

	cs.style = WS_OVERLAPPED | WS_CAPTION | FWS_ADDTOTITLE
		| WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_MAXIMIZE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

CIBFlowView* CMainFrame::SetActiveWnd(LPCTSTR lpszDocTitle,CXISLTag *pDrawTag)
{
	// ŏ̃hLggv[g̈ʒu擾
    POSITION posTemplate = AfxGetApp()->GetFirstDocTemplatePosition();
    while(posTemplate != NULL)    // H
    {
        // hLgev[gւ̃|C^擾
        CDocTemplate* pTemplate = AfxGetApp()->GetNextDocTemplate(posTemplate);
        if(pTemplate != NULL)      // H
        {
			CString strDoc;
			pTemplate->GetDocString(strDoc,CDocTemplate::filterExt);

			if(strDoc.Compare(".xisl") == 0)
			{
				// hLg̎擾
				POSITION posDoc = pTemplate->GetFirstDocPosition();
				while(posDoc != NULL)
				{
					CXISLDoc *pDoc = (CXISLDoc*)pTemplate->GetNextDoc(posDoc);
					if(pDoc->GetTitle().Compare(lpszDocTitle) == 0)
					{
						POSITION pos = pDoc->GetFirstViewPosition();
						CView* pView = pDoc->GetNextView(pos);
						if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
						{
							CFrameWnd *pFrame = pView->GetParentFrame();
							if(pFrame->IsIconic())
								pFrame->ShowWindow(SW_SHOWNORMAL);
							else
								MDIActivate(pFrame);
							((CIBFlowView*)pView)->ReDrawXISLTag(pDrawTag);
							return (CIBFlowView*)pView;
						}
					}
				}
			}
        }
    }
	return NULL;
}

//֐Fvoid CMainFrame::DragReady(int nDropType,int nDlgItemID,int nDraggingBmpID,int nResetBmpID)
//@\	FD&D̏sDD&DɍsOnDrop֐Ă΂
//	Fint nDropType		FhbvACe
//		@int nDlgItemID	FI_CAOo[ACeID
//		@int nDraggingBmpIDFhbObitmapw
//		@int nResetBmpID	FhbObitmap
//߂lFȂ
void CMainFrame::DragReady(int nDropType,int nDlgItemID,int nDraggingBmpID,int nResetBmpID)
{
	//IĂ^O
//	if(m_pSelectTag)
//	{
//		CDC *pDC = GetDC();
//		CRect rect;
//		m_pSelectTag->GetRectBMP(&rect);
//		pDC->InvertRect(&rect);
//		m_pSelectTag = NULL;
//	}

	HGLOBAL hGlobal = ::GlobalAlloc(GHND|GMEM_SHARE, sizeof(char)*15);
	char *pcstrType = (char*)GlobalLock(hGlobal);
	itoa(nDropType,pcstrType,10);
	::GlobalUnlock(hGlobal);

	CIBOleDropSource dropSource;
	COleDataSource dataSource;                      //  f[^\[XIuWFNgCX^X
	dataSource.CacheGlobalData(CF_TEXT, hGlobal);   //  쐬f[^ݒ

	CStatic *pStatic;
	if(nDropType & ID_DROPOK_TAGALLOK)
		pStatic = (CStatic*)g_pTagBar->GetDlgItem(nDlgItemID);
	else
		pStatic = (CStatic*)g_pTagBar->GetDlgItem(nDlgItemID);

	pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(nDraggingBmpID) ) );

	DROPEFFECT result = dataSource.DoDragDrop(DROPEFFECT_COPY|DROPEFFECT_MOVE,NULL,&dropSource);
	dataSource.FlushClipboard(); 
	GlobalFree( hGlobal );

	pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(nResetBmpID) ) );
}

//֐	Fvoid CMainFrame::SetBarItem(int nDropOKItem)
//@\		F_CAOo[̃rbg}bvԂɍ킹ĕύX
//		Fint nDropOKItem:ANeBuɂACetO
//߂l	FȂ
void CMainFrame::SetBarItem(int nDropOKItem)
{
	m_nDropOKItem = nDropOKItem;
//	m_nDropOKItem = ID_DROPOK_ALLOK;
	CStatic *pStatic;
	//Tag_Bar̕ύX
	int nDropItem = ID_DROPOK_DIALOG;
	int nIndex = 0;
	while(nDropItem <= ID_DROPOK_TAG_FINISH)
	{
		pStatic = (CStatic*)m_wndTAGDlgBar.GetDlgItem(TAGBAR_BMP_ITEM[nIndex]);
		if(m_nDropOKItem & nDropItem)
			pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(TAGBAR_DRAGOK_BMPID[nIndex]) ) );
		else
			pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(TAGBAR_DRAGNONE_BMPID[nIndex]) ) );

		nDropItem = nDropItem << 1;
		nIndex++;
	}
	//Modality_Bar̕ύX
	nDropItem = ID_DROPOK_SPEECH;
	nIndex = 0;
	while(nDropItem <= ID_DROPOK_MOD_FINISH)
	{
		pStatic = (CStatic*)m_wndTAGDlgBar.GetDlgItem(MODBAR_BMP_ITEM[nIndex]);
		if(m_nDropOKItem & nDropItem)
			pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(MODBAR_DRAGOK_BMPID[nIndex]) ) );
		else
			pStatic->SetBitmap( ::LoadBitmap( ::AfxGetApp()->m_hInstance, MAKEINTRESOURCE(MODBAR_DRAGNONE_BMPID[nIndex]) ) );

		nDropItem = nDropItem << 1;
		nIndex++;
	}
}

void CMainFrame::JointToolBar(CFrameWnd *_pFrameWnd,CControlBar *_pBar,CControlBar *_pCB)
{
	DWORD dw;
	UINT n=0;
	CRect rect;

	_pFrameWnd->RecalcLayout();
	_pCB->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=_pCB->GetBarStyle();
	n = (dw & CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw & CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw & CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw & CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	_pFrameWnd->DockControlBar(_pBar,n,&rect);
}

//܂łɓǂݍ܂Ăcall,gotȏJڐ_~[dialog
//vdialogΒu
void CMainFrame::ReplaceNCDTag2DTag(CXISLRootTag *pRTag)
{
	POSITION pos = pRTag->m_xislList.GetHeadPosition();
	BOOL bTop = TRUE;
	while(pos)
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)pRTag->m_xislList.GetNext(pos);
		CXISLDialogTag *pDummyDTag = FindNCDTagList(pDTag->GetDocName(),pDTag->GetDialogID(),bTop);
		if( pDummyDTag == NULL)
			continue;
		
		POSITION pos = pDummyDTag->m_ReCallList.GetHeadPosition();
		while(pos)
		{
			CXISLCallTag *pCallTag = (CXISLCallTag*)pDummyDTag->m_ReCallList.GetNext(pos);
			pCallTag->m_pNextDialog = pDTag;
			pDummyDTag->RemoveReCallTag(pCallTag);
			pDTag->AddReCallTag(pCallTag);
		}
		RemoveNCDTagList(pDummyDTag);
		delete pDummyDTag; pDummyDTag = NULL;
		bTop = FALSE;
	}
}


//܂łɓǂݍ܂Ăcall,gotȏJڐdialog
//_~[dialogɒu
void CMainFrame::ReplaceDTag2NCDTag(CXISLRootTag *pRTag)
{
	POSITION pos = pRTag->m_xislList.GetHeadPosition();
	while(pos)
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)pRTag->m_xislList.GetNext(pos);
		CXISLDialogTag *pDummyDTag = FindNCDTagList(pDTag->GetDocName(),pDTag->GetDialogID());
		if(pDummyDTag)
			ASSERT(NULL);//_~[dialoĝ͂

		if(!pDTag->m_ReCallList.IsEmpty())
		{
			pDummyDTag = new CXISLDialogTag;
			pDummyDTag->SetDummy(pDTag->GetDialogArgCount(),pDTag->GetDocName());
			pDummyDTag->SetDocName(pDTag->GetDocName());
			pDummyDTag->SetDialogAttribute(pDTag->GetDialogID(),0,0,0);
			
			POSITION pos = pDTag->m_ReCallList.GetHeadPosition();
			while(pos)
			{
				CXISLCallTag *pCallTag = (CXISLCallTag*)pDTag->m_ReCallList.GetNext(pos);
				pCallTag->m_pNextDialog = pDummyDTag;
				pDTag->RemoveReCallTag(pCallTag);
				pDummyDTag->AddReCallTag(pCallTag);
			}
			AddNCDTagList(pDummyDTag);
		}
	}
}

void CMainFrame::AddNCDTagList(CXISLDialogTag *pDTag)
{
	if(!m_NonConnectionDTagList.IsEmpty())
	{
		if(m_NonConnectionDTagList.Find(pDTag) != NULL)
			ASSERT(NULL);//̂o^̂͂
	}

	m_NonConnectionDTagList.AddTail(pDTag);
}

void CMainFrame::RemoveNCDTagList(CXISLDialogTag *pDTag)
{
	POSITION pos = m_NonConnectionDTagList.Find(pDTag);
	ASSERT(pos);

	//܂ǂcallĂ΂Ăꍇ̓XgOȂ
	if(pDTag->GetReCallTagCount() == 0)
		m_NonConnectionDTagList.RemoveAt(pos);
}

CXISLDialogTag* CMainFrame::FindNCDTagList(LPCTSTR lpszDocName,LPCTSTR lpszID,BOOL bTop)
{
	POSITION pos = m_NonConnectionDTagList.GetHeadPosition();
	while(pos)
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_NonConnectionDTagList.GetNext(pos);
		if(strcmp(lpszDocName,pDTag->GetDocName()) == 0)
		{
			if(bTop)
			{
				if(strcmp(pDTag->GetDialogID(),"TOPDIALOG_IB") == 0)
					return pDTag;
			}
			if(strcmp(lpszID,pDTag->GetDialogID()) == 0)
				return pDTag;
		}
	}

	return NULL;
}

//݊JĂqEBhESĕC
void CMainFrame::ResetApplication()
{
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_PATH),"");
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_FORM),"");
//	((CIBApp*)AfxGetApp)->ResetBrowser();
	// ŏ̃hLggv[g̈ʒu擾
    POSITION posTemplate = AfxGetApp()->GetFirstDocTemplatePosition();
    while(posTemplate != NULL)    // H
    {
        // hLgev[gւ̃|C^擾
        CDocTemplate* pTemplate = AfxGetApp()->GetNextDocTemplate(posTemplate);
		CString strDoc;
		pTemplate->GetDocString(strDoc,CDocTemplate::filterExt);
        if(pTemplate != NULL)      // H
        {
			if(pTemplate->SaveAllModified())
			{
				pTemplate->CloseAllDocuments(TRUE);
				if(strDoc.Compare(".xisl") == 0)
				{
					if(g_pAppVarList)
					{
						delete g_pAppVarList;
						g_pAppVarList = NULL;
					}
					g_pAppRootTag = NULL;
					g_pOprTargetView = NULL;
				}
			}
		}
	}

	while(!m_NonConnectionDTagList.IsEmpty())
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_NonConnectionDTagList.RemoveHead();
		delete pDTag; pDTag = NULL;
	}
}

void CMainFrame::ConnectIPAEngine(CFSMOutputDlg *pFSMDlg)
{
	if(m_pFSMClient == NULL || m_pSSMClient == NULL)
		return;
	if(!m_pFSMClient->IsActive() || !m_pSSMClient->IsActive())
		return;

	m_pFSMClient->m_pFSMDlg = pFSMDlg;
	m_pSSMClient->m_pFSMDlg = pFSMDlg;
	m_pSSMClient->m_pTTSDlg = NULL;

	pFSMDlg->m_pFSMClient = m_pFSMClient;
	pFSMDlg->m_pSSMClient = m_pSSMClient;
}

void CMainFrame::ConnectIPAEngine(COutputTTSDlg *pTTSDlg)
{
	if(m_pSSMClient == NULL)
		return;
	if(!m_pSSMClient->IsActive())
		return;

	m_pSSMClient->m_pFSMDlg = NULL;
	m_pSSMClient->m_pTTSDlg = pTTSDlg;

	pTTSDlg->m_pSSMClient = m_pSSMClient;

}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh


void CMainFrame::RecalcLayout(BOOL bNotify) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	CMDIFrameWnd::RecalcLayout(bNotify);
	CMDIFrameWnd::RecalcLayout(bNotify);
}

void CMainFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{
	CMDIFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ

	//XISLf[^݂Ȃ"C^NV̍쐬"͖
/*	CChildFrame *pChildFrm = (CChildFrame*)MDIGetActive();
	if( pChildFrm )
	{
		CIBDoc *pDoc = (CIBDoc*)pChildFrm->GetActiveDocument();

		if(pDoc->nDoctyp & ID_VIEW_XISL)
			pPopupMenu->EnableMenuItem(ID_NEW_XISL, MF_GRAYED);
	}
*/

	//"XISL֌W"̃j[͖(ftHg)
//	pPopupMenu->EnableMenuItem(IDM_XISL_HEAD, MF_GRAYED);
/*	pPopupMenu->EnableMenuItem(IDM_XISL_DIALOG_INSERT, MF_GRAYED);
	pPopupMenu->EnableMenuItem(IDM_XISL_EXCHANGE_INSERT, MF_GRAYED);
	pPopupMenu->EnableMenuItem(IDM_XISL_DIAEXC_INSERT, MF_GRAYED);
	pPopupMenu->EnableMenuItem(IDM_XISL_BEGIN_INSERT, MF_GRAYED);
	pPopupMenu->EnableMenuItem(IDM_XISL_END_INSERT, MF_GRAYED);

	CInteractionToolView *pITView = 
		(CInteractionToolView*)m_wndSTCBar.GetView( RUNTIME_CLASS(CInteractionToolView) );

	if(pITView->m_strSelectName.Compare("xisl") == 0)
		pPopupMenu->EnableMenuItem(IDM_XISL_DIALOG_INSERT, MF_ENABLED);
	if(pITView->m_strSelectName.Compare("dialog") == 0
		|| pITView->m_strSelectName.Compare("seq_exchange") == 0
		|| pITView->m_strSelectName.Compare("par_exchange") == 0
		|| pITView->m_strSelectName.Compare("alt_exchange") == 0)
	{
		pPopupMenu->EnableMenuItem(IDM_XISL_EXCHANGE_INSERT, MF_ENABLED);
		pPopupMenu->EnableMenuItem(IDM_XISL_DIAEXC_INSERT, MF_ENABLED);
		pPopupMenu->EnableMenuItem(IDM_XISL_BEGIN_INSERT, MF_ENABLED);
		pPopupMenu->EnableMenuItem(IDM_XISL_END_INSERT, MF_ENABLED);
	}
	*/
}

void CMainFrame::OnClose() 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	ResetApplication();

	while(!m_NonConnectionDTagList.IsEmpty())
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_NonConnectionDTagList.RemoveHead();
		delete pDTag; pDTag = NULL;
	}

	if(m_pFSMClient)
	{
		if(m_pFSMClient->IsActive())
		{
			m_pFSMClient->Stop();
			m_pFSMClient->m_Socket.Close();
		}
		delete m_pFSMClient; m_pFSMClient = NULL;
	}
	if(m_pSSMClient)
	{
		if(m_pSSMClient->IsActive())
		{
			m_pSSMClient->Stop();
			m_pSSMClient->m_Socket.Close();
		}
		delete m_pSSMClient; m_pSSMClient = NULL;
	}
	CMDIFrameWnd::OnClose();
}

///////////_CAOo[̃nh//////////////////
void CMainFrame::OnTagDialogClick()
{
	if(m_nDropOKItem & ID_DROPOK_DIALOG)
		DragReady(ID_DROPOK_DIALOG,IDC_TAGBAR_XISL_DIALOG,IDB_TAG_DIALOG_DRAGGING,IDB_TAG_DIALOG);
}

void CMainFrame::OnTagExchangeClick()
{
	if(m_nDropOKItem & ID_DROPOK_EXCHANGE)
		DragReady(ID_DROPOK_EXCHANGE,IDC_TAGBAR_XISL_EXCHANGE,IDB_TAG_EXCHANGE_DRAGGING,IDB_TAG_EXCHANGE);
}

void CMainFrame::OnTagBeginClick()
{	
	if(m_nDropOKItem & ID_DROPOK_BEGIN)
		DragReady(ID_DROPOK_BEGIN,IDC_TAGBAR_XISL_BEGIN,IDB_TAG_BEGIN_DRAGGING,IDB_TAG_BEGIN);
}

void CMainFrame::OnTagEndClick()
{
	if(m_nDropOKItem & ID_DROPOK_END)
		DragReady(ID_DROPOK_END,IDC_TAGBAR_XISL_END,IDB_TAG_END_DRAGGING,IDB_TAG_END);
}

void CMainFrame::OnTagSeqClick()
{
	if(m_nDropOKItem & ID_DROPOK_SEQ)
		DragReady(ID_DROPOK_SEQ,IDC_TAGBAR_XISL_SEQ,IDB_TAG_SEQ_DRAGGING,IDB_TAG_SEQ);
}

void CMainFrame::OnTagParClick()
{
	if(m_nDropOKItem & ID_DROPOK_PAR)
		DragReady(ID_DROPOK_PAR,IDC_TAGBAR_XISL_PAR,IDB_TAG_PAR_DRAGGING,IDB_TAG_PAR);
}

void CMainFrame::OnTagAltClick()
{
	if(m_nDropOKItem & ID_DROPOK_ALT)
		DragReady(ID_DROPOK_ALT,IDC_TAGBAR_XISL_ALT,IDB_TAG_ALT_DRAGGING,IDB_TAG_ALT);
}

void CMainFrame::OnTagGotoClick()
{
	if(m_nDropOKItem & ID_DROPOK_GOTO)
		DragReady(ID_DROPOK_GOTO,IDC_TAGBAR_XISL_GOTO,IDB_TAG_GOTO_DRAGGING,IDB_TAG_GOTO);
}

void CMainFrame::OnTagCallClick()
{
	if(m_nDropOKItem & ID_DROPOK_CALL)
		DragReady(ID_DROPOK_CALL,IDC_TAGBAR_XISL_CALL,IDB_TAG_CALL_DRAGGING,IDB_TAG_CALL);
}

void CMainFrame::OnTagReturnClick()
{
	if(m_nDropOKItem & ID_DROPOK_RETURN)
		DragReady(ID_DROPOK_RETURN,IDC_TAGBAR_XISL_RETURN,IDB_TAG_RETURN_DRAGGING,IDB_TAG_RETURN);
}

void CMainFrame::OnTagAssignClick()
{
	if(m_nDropOKItem & ID_DROPOK_ASSIGN)
		DragReady(ID_DROPOK_ASSIGN,IDC_TAGBAR_XISL_ASSIGN,IDB_TAG_ASSIGN_DRAGGING,IDB_TAG_ASSIGN);
}

void CMainFrame::OnTagSwitchClick()
{
	if(m_nDropOKItem & ID_DROPOK_SWITCH)
		DragReady(ID_DROPOK_SWITCH,IDC_TAGBAR_XISL_SWITCH,IDB_TAG_SWITCH_DRAGGING,IDB_TAG_SWITCH);
}

void CMainFrame::OnTagExitClick()
{
	if(m_nDropOKItem & ID_DROPOK_EXIT)
		DragReady(ID_DROPOK_EXIT,IDC_TAGBAR_XISL_EXIT,IDB_TAG_EXIT_DRAGGING,IDB_TAG_EXIT);
}

void CMainFrame::OnTagIFClick()
{
	if(m_nDropOKItem & ID_DROPOK_IF)
		DragReady(ID_DROPOK_IF,IDC_TAGBAR_XISL_IF,IDB_TAG_IF_DRAGGING,IDB_TAG_IF);
}

void CMainFrame::OnModSpeechClick()
{
	if(m_nDropOKItem & ID_DROPOK_SPEECH)
		DragReady(ID_DROPOK_SPEECH,IDC_MODBAR_INPUT_SPEECH,IDB_MOD_SPEECH_DRAGGING,IDB_MOD_SPEECH);
}

void CMainFrame::OnModTouchClick()
{
	if(m_nDropOKItem & ID_DROPOK_TOUCH)
		DragReady(ID_DROPOK_TOUCH,IDC_MODBAR_INPUT_TOUCH,IDB_MOD_TOUCH_DRAGGING,IDB_MOD_TOUCH);
}

void CMainFrame::OnModWindowClick()
{
	if(m_nDropOKItem & ID_DROPOK_WINDOW)
		DragReady(ID_DROPOK_WINDOW,IDC_MODBAR_OUTPUT_WINDOW,IDB_MOD_WINDOW_DRAGGING,IDB_MOD_WINDOW);
}

void CMainFrame::OnModTTSClick()
{
	if(m_nDropOKItem & ID_DROPOK_TTS)
		DragReady(ID_DROPOK_TTS,IDC_MODBAR_OUTPUT_TTS,IDB_MOD_TTS_DRAGGING,IDB_MOD_TTS);
}

void CMainFrame::OnModFsmClick()
{
	if(m_nDropOKItem & ID_DROPOK_FSM)
		DragReady(ID_DROPOK_FSM,IDC_MODBAR_OUTPUT_FSM,IDB_MOD_FSM_DRAGGING,IDB_MOD_FSM);
}

//vvgNbNꍇ
void CMainFrame::OnTagPromptClick()
{
	if(m_nDropOKItem & ID_DROPOK_IF)
		DragReady(ID_DROPOK_PROMPT,IDC_TAGBAR_XISL_PROMPT,IDB_TAG_PROMPT_DRAGGING,IDB_TAG_PROMPT);
}

//RepromptNbNꍇ
void CMainFrame::OnTagRepromptClick()
{
	if(m_nDropOKItem & ID_DROPOK_IF)
		DragReady(ID_DROPOK_REPROMPT,IDC_TAGBAR_XISL_REPROMPT,IDB_TAG_REPROMPT_DRAGGING,IDB_TAG_REPROMPT);
}

//FSM̎s
void CMainFrame::OnRunFsm() 
{
	if(m_nValidate==0){
		MessageBox("SẴGWݒ肳ĂȂ̂ŁANł܂\nj[̐ݒ肩eGWݒ肵Ă","x",MB_OK|MB_ICONERROR);
		return;
	}
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	BOOL bNew = FALSE;
	if(m_pFSMClient == NULL)
	{
		bNew = TRUE;
		m_pFSMClient = new CFSMClient;
	}

	if(m_pFSMClient->IsActive())
	{
		m_pFSMClient->Stop();
		m_pFSMClient->m_Socket.Close();
		delete m_pFSMClient; m_pFSMClient = NULL;
		return;
	}
	else if(!bNew)
	{
		delete m_pFSMClient; m_pFSMClient = NULL;
		m_pFSMClient = new CFSMClient;
	}

	CWinApp *pApp = AfxGetApp();
	CString strFSM = pApp->GetProfileString("FSM","Path",NULL);
	CString strCurrent = strFSM.Left(strFSM.ReverseFind('\\')+1);

	PROCESS_INFORMATION pi;
	STARTUPINFO si;
    // CreateProcess()̈ݒ
    ZeroMemory(&si, sizeof(STARTUPINFO));
    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_SHOW;
//    si.wShowWindow = SW_MINIMIZE;	

    if(!CreateProcess(NULL,
			strFSM.GetBuffer(strFSM.GetLength()),
//            _T("D:\\IPA\\engine\\FSM\\FSM\\bin\\fsm_d.exe"),
            NULL,
            NULL,
            FALSE,  
            0,  
            NULL,
			strCurrent.GetBuffer(strCurrent.GetLength()),
//            _T("D:\\IPA\\engine\\FSM\\FSM\\bin\\"),  
            &si,  
            &pi)){  
		pApp->WriteProfileInt("ENGINE","Validate",0);
        AfxMessageBox(_T("FSMNł܂ł\nċNƐݒ_CAO\܂"));  
		return;
	}
	strFSM.ReleaseBuffer();
	strCurrent.ReleaseBuffer();

	Sleep(2000);
	if(!m_pFSMClient->Initialize())
	{
		AfxMessageBox("FSM̐ڑɎs܂D");
		m_pFSMClient->m_Socket.Close();
		WSACleanup();
		return;
	}
	m_pFSMClient->Run();

	if(m_pSSMClient == NULL)
		OnRunSsm();
}

//SSM̎s
void CMainFrame::OnRunSsm() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	if(m_nValidate==0){
		MessageBox("SẴGWݒ肳ĂȂ̂ŁANł܂\nj[̐ݒ肩eGWݒ肵Ă","x",MB_OK|MB_ICONERROR);
		return;
	}
	BOOL bNew=FALSE;
	if(m_pSSMClient == NULL)
	{
		bNew = TRUE;
		m_pSSMClient = new CSSMClient;
	}

	if(m_pSSMClient->IsActive())
	{
		m_pSSMClient->Stop();
		m_pSSMClient->m_Socket.Close();
		delete m_pSSMClient; m_pSSMClient = NULL;
		return;
	}
	else if(!bNew)
	{
		delete m_pSSMClient; m_pSSMClient = NULL;
		m_pSSMClient = new CSSMClient;
	}

	//AvP[VIuWFNg擾
	CWinApp *pApp = AfxGetApp();
	CString strGTalk = pApp->GetProfileString("SSM","Path",NULL);
	CString strCurrent = strGTalk.Left(strGTalk.ReverseFind('\\')+1);
	CString strSsmconf = pApp->GetProfileString("SSM","ConfigFile",NULL);
	int nPort = pApp->GetProfileInt("SSM","Port",0);

	///////////////////////////////////////////////
	//gtalk̋N
	///////////////////////////////////////////////
	//R}hvvg̐ݒ
	CString strCmdLine;
	if(strSsmconf.Find("..\\..\\")==-1){
		//ssm.conf΃pXŐݒ肳ĂȂ
		strCmdLine.Format("%s -C %s -p %d ",strGTalk,strSsmconf,nPort);
	}
	else{
		//ssm.conf΃pXŐݒ肳Ă鎞
		strCmdLine.Format("%s -C ssm.conf -p %d ",strGTalk,nPort);
	}

	PROCESS_INFORMATION pi;
	STARTUPINFO si;
    // CreateProcess()̈ݒ
    ZeroMemory(&si, sizeof(STARTUPINFO));
    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_MINIMIZE;

    if(!CreateProcess(NULL,
			strCmdLine.GetBuffer(strCmdLine.GetLength()),
//            _T("D:\\IPA\\engine\\SSM\\gtalk\\Release\\gtalk.exe"),
            NULL,
            NULL,  
            FALSE,  
            0,  
            NULL,  
            strCurrent.GetBuffer(strCurrent.GetLength()),//NULL,//_T("D:\\IPA\\engine\\SSM\\gtalk\\Release\\"),
            &si,  
            &pi)){
		pApp->WriteProfileInt("ENGINE","Validate",0);
        AfxMessageBox(_T("gtalkNł܂ł\nċNƐݒ_CAO\܂"));  
	}
	strCmdLine.ReleaseBuffer();
	strSsmconf.ReleaseBuffer();
	strGTalk.ReleaseBuffer();
	strCurrent.ReleaseBuffer();

	WaitForInputIdle(pi.hProcess,INFINITE);
	Sleep(1500);
	if(!m_pSSMClient->Initialize())
	{
		AfxMessageBox("SSM:ڑvs");
		m_pSSMClient->m_Socket.Close();
		WSACleanup();
		return;
	}
	m_pSSMClient->Run();
}

//eXg[h
//2003/7/2
//ŏIXV2003/7/15
void CMainFrame::OnRunTest()
{
	if(m_nValidate==0){
		MessageBox("SẴGWݒ肳ĂȂ̂ŁANł܂\nj[̐ݒ肩eGWݒ肵Ă","x",MB_OK|MB_ICONERROR);
		return;
	}
	DWORD ExitCode;	
	GetExitCodeProcess(m_fepi.hProcess,&ExitCode);
	TerminateProcess(m_fepi.hProcess,(UINT)ExitCode);
	CloseHandle(m_fepi.hProcess);
	GetExitCodeProcess(m_impi.hProcess,&ExitCode);
	TerminateProcess(m_impi.hProcess,(UINT)ExitCode);
	CloseHandle(m_impi.hProcess);

	/////////////////////////////
	//NɌx
	////////////////////////////
	//MessageBox("IMFrontEndNeXg[hɓ܂\neXg[ĥeXgł̂Ŏvʕsꍇ܂","x",MB_OK|MB_ICONWARNING);

	////////////////////////////
	//SSMFSM̏I
	///////////////////////////
	//SSMɋNĂ邩H
	if(m_pSSMClient != NULL){
		if(m_pSSMClient->IsActive())
		{
			m_pSSMClient->Stop();
			m_pSSMClient->m_Socket.Close();
			delete m_pSSMClient; m_pSSMClient = NULL;
		}
	}
	//FSMɋNĂ邩H
	if(m_pFSMClient != NULL){
		if(m_pFSMClient->IsActive())
		{
			m_pFSMClient->Stop();
			m_pFSMClient->m_Socket.Close();
			delete m_pFSMClient; m_pFSMClient = NULL;
		}
	}

	////////////////////////////
	//st@C̎w
	///////////////////////////
	CString Selectstr="file://";
	CTestFileSelect tfsdlg;
	//I_CAO̕\
	if(tfsdlg.DoModal()==IDCANCEL)
		return;
	

	char cbuuferPath[MAX_PATH];
	char cPath[MAX_PATH];
	//pX̏
	ZeroMemory(cPath,sizeof(cPath));
	ZeroMemory(cbuuferPath,sizeof(cbuuferPath));
	GetCurrentDirectory(MAX_PATH,cbuuferPath);//݂̃JgfBNgޔ
	int dir_length = strlen(cPath);//擾t@Cl[̒擾(fBNg܂)
	//AvP[VIuWFNg擾
	CWinApp *pApp = AfxGetApp();
	//JgfBNg̐ݒ
	if(strlen(((CIBApp *)pApp)->GetSelectDir())==0){//JgfBNg̃pX
		MessageBox("JgfBNgsłB\nIBċNĂ",NULL,MB_OK);
		exit(1);
	}
	else {
		//JgfBNgݒ肷
		SetCurrentDirectory(((CIBApp *)pApp)->GetSelectDir());
		//It@C̐ݒ
		Selectstr += ((CIBApp *)pApp)->GetSelectDir();
		Selectstr += "\\";
		Selectstr += tfsdlg.GetSelectStr();
		Selectstr += ".xisl";
	}
	
	///////////////////////////
	//t@C̕ۑ
	///////////////////////////
	//hLg̎擾
	POSITION pos = pApp->GetFirstDocTemplatePosition();
	CDocTemplate* pTemplate = pApp->GetNextDocTemplate(pos);
	POSITION tpos = pTemplate->GetFirstDocPosition();
	//쐬XISLt@Cۑ
	CString str;
	while(tpos!=NULL){
		CXISLDoc *pDoc = (CXISLDoc *)pTemplate->GetNextDoc(tpos);
		str = pDoc->GetTitle() + ".xisl";
		HANDLE hObject =CreateFile(str,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		str = pDoc->GetXISL();
		DWORD BytesWritten;
		//OVERLAPPED lpOverlapped;sizeof(str.GetBuffer(str.GetLength()))
		if(WriteFile(hObject,str,str.GetLength(),&BytesWritten,NULL)==0){
			MessageBox("Write Error",NULL,MB_OK);
			CloseHandle(hObject);
			return;
		}
		CloseHandle(hObject);
		str.ReleaseBuffer();
	}
	//pX̏
	ZeroMemory(cPath,sizeof(cPath));

	///////////////////////////
	//Ot@C̐ݒǂݍ
	///////////////////////////
	GetModuleFileName(NULL, cPath, sizeof(cPath));//AvP[V̂fBNg擾(t@Ct)
	dir_length = strlen(cPath);//擾t@Cl[̒擾(fBNg܂)
	//AvP[V
	while(dir_length){
		if(cPath[dir_length]=='\\'){
			cPath[dir_length]='\0';
			break;
		}
		else
			dir_length--;
	}
	//JgfBNgݒ
	SetCurrentDirectory(cPath);
	CString strIM = pApp->GetProfileString("IM","Path",NULL);//Θb䕔
	CString strFE = pApp->GetProfileString("FRONTEND","Path",NULL);//tgGh
	CString strCurrent;//Jgݒ
//	PROCESS_INFORMATION m_impi;
//	PROCESS_INFORMATION m_fepi;
	STARTUPINFO imsi;
	STARTUPINFO fesi;
	//pX̏
	ZeroMemory(cPath,sizeof(cPath));

	///////////////////////////
	//Θb䕔̋N
	///////////////////////////
/*	//Θb䕔̃AvP[V
	dir_length=strIM.GetLength();
	CopyMemory(cPath,strIM.GetBuffer(dir_length),dir_length);
	while(dir_length){
		if(cPath[dir_length]=='\\'){
			cPath[dir_length]='\0';
			break;
		}
		else
			dir_length--;
	}
	//JgfBNg擾
	//SetCurrentDirectory(cPath);
    // CreateProcess()̈ݒ*/
	//JgfBNgݒ
	strCurrent = strIM.Left(strIM.ReverseFind('\\')+1);
	ZeroMemory(&imsi, sizeof(STARTUPINFO));
	ZeroMemory(&m_impi, sizeof(PROCESS_INFORMATION));
	imsi.cb = sizeof(STARTUPINFO);
	imsi.dwFlags = STARTF_USESHOWWINDOW;
	imsi.wShowWindow = SW_MINIMIZE;
	if(!CreateProcess(NULL,
		strIM.GetBuffer(strIM.GetLength()),
		NULL,
	    NULL,  
	    FALSE,  
	    0,  
	    NULL,  
	    strCurrent,
	    &imsi,  
	    &m_impi)){
		pApp->WriteProfileInt("ENGINE","Validate",0);
		AfxMessageBox(_T("IMNł܂ł\nċNƐݒ_CAO\܂"));  
	}
	strIM.ReleaseBuffer();
	if(WaitForInputIdle(m_impi.hProcess,INFINITE)==-1){
		MessageBox("ERROR start IM",NULL,MB_OK);
	}

	//pX̏
	ZeroMemory(cPath,sizeof(cPath));

	///////////////////////////
	//tgGh̋N
	///////////////////////////
/*	//tgGh̃AvP[V
	dir_length=strFE.GetLength();
	CopyMemory(cPath,strFE.GetBuffer(dir_length),dir_length);
	while(dir_length){
		if(cPath[dir_length]=='\\'){
			cPath[dir_length]='\0';
			break;
		}
		else
			dir_length--;
	}
	//JgfBNg擾
	//SetCurrentDirectory(cPath);
	*/
	//JgfBNgݒ
	strCurrent = strFE.Left(strFE.ReverseFind('\\')+1);
	ZeroMemory(&fesi, sizeof(STARTUPINFO));
	ZeroMemory(&m_fepi, sizeof(PROCESS_INFORMATION));
	fesi.cb = sizeof(STARTUPINFO);
	fesi.dwFlags = STARTF_USESHOWWINDOW;
	fesi.wShowWindow = SW_SHOW;
	if(!CreateProcess(NULL,
		strFE.GetBuffer(strFE.GetLength()),
		NULL,
		NULL,  
		FALSE,  
		0,  
		NULL,  
		strCurrent,
		&fesi,  
		&m_fepi)){
			pApp->WriteProfileInt("ENGINE","Validate",0);
			AfxMessageBox(_T("FrontEndNł܂ł\nċNƐݒ_CAO\܂"));  
		}
	strFE.ReleaseBuffer();
	if(WaitForInputIdle(m_fepi.hProcess,INFINITE)==-1){
		MessageBox("ERROR start FE",NULL,MB_OK);
	}
	Sleep(1500);
	/////////////////////////////////////
	//st@CURIΘb䕔ɓn
	/////////////////////////////////////
	int		nResult;
	WORD	wRequireVersion;
	WSADATA	lpWSAData;
	struct sockaddr_in	 m_DMAddr;//AhX
	SOCKET Accept = INVALID_SOCKET;
	SOCKET sock = INVALID_SOCKET;

	wRequireVersion = MAKEWORD( 2, 0 );//WinSock̃o[Wݒ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );//
	if(nResult==0){
		m_DMAddr.sin_family = AF_INET;
		m_DMAddr.sin_addr.s_addr = NULL;
		m_DMAddr.sin_addr.s_addr = inet_addr( "127.0.0.1" );
		m_DMAddr.sin_port = htons( 20200 );
		string msg = "<msg><head><from>FrontEnd</from><to>DialogMngr</to></head>";
		msg += "<body><command>start_session</command><parameter><uri>" + Selectstr + "</uri></parameter></body></msg>";
		//msg += "http://192.168.3.69/G_PC_AIR/DemoAIR.xisl";
		//msg += "</uri></parameter></body></msg>";
		//While͈Ӗ(@LT`)@H
		while(1){
			//\Pbg̍쐬
			if( ( sock = socket( AF_INET, SOCK_STREAM, IPPROTO_IP ) ) != INVALID_SOCKET  && (Accept = socket( AF_INET, SOCK_STREAM, IPPROTO_IP ) ) != INVALID_SOCKET){
				struct sockaddr_in si;
				si.sin_family = AF_INET;
				si.sin_addr.s_addr = NULL;
				si.sin_addr.s_addr = inet_addr( "127.0.0.1" );;
				si.sin_port = htons( 20300 );
				//oCh
				if( bind( Accept, reinterpret_cast< sockaddr* >( &si ), sizeof( sockaddr_in ) ) != SOCKET_ERROR )
				{
					//RlNg
					if( connect( sock, reinterpret_cast< struct sockaddr*>( &m_DMAddr ), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
					{
						// error
						MessageBox("ڑs",NULL,MB_OK);
						shutdown( sock, 0x02 );
						shutdown( Accept, 0x02 );
						closesocket( sock );
						closesocket( Accept );
						WSACleanup();
						break;
					}
		
					size_t nSize = msg.length();
					size_t nRet = 0;
					int nRetBuf = 0;
					while( 1 )
					{
						if( nRet >= nSize )
							break;
						nRetBuf = send( sock, &(msg.c_str())[nRet], nSize - nRet, 0 );
						if(nRetBuf == SOCKET_ERROR)
							break;
						nRet += nRetBuf;
					}
					shutdown( sock, 0x02 );
					shutdown( Accept, 0x02 );
					closesocket( sock );
					closesocket( Accept );
					WSACleanup();
					break;
				}
			}
		}
	}
	// FEI܂Ő߂܂
	//WaitForInputIdle( m_fepi.hProcess, INFINITE );
	//WaitForSingleObject( m_fepi.hProcess, INFINITE );
	// IMI܂Ő߂܂
	//WaitForInputIdle( m_impi.hProcess, INFINITE );
	//WaitForSingleObject( m_impi.hProcess, INFINITE );
	Selectstr.ReleaseBuffer();

}
void CMainFrame::OnUpdateRunSsm(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->Enable();
	if(m_pSSMClient)
		pCmdUI->SetCheck(m_pSSMClient->IsActive());	
	else
		pCmdUI->SetCheck(0);	
}

void CMainFrame::OnUpdateRunFsm(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->Enable();
	if(m_pFSMClient)
		pCmdUI->SetCheck(m_pFSMClient->IsActive());
	else
		pCmdUI->SetCheck(0);
}

void CMainFrame::OnCfgEngin()
{
	CCFGEngineDlg cfgEngDlg;
	cfgEngDlg.DoModal();
}